# 导入海龟绘图库
import turtle
# 初始化绘图窗口
screen = turtle. Screen()
screen. title("奥运五环旗") # 设置窗口标题
screen. bgcolor("white") # 设置背景为白色
# 创建画笔对象
pen = turtle. Turtle()
pen. speed(5) # 设置绘制速度为 5(1 ~10 渐快,0 为最快)
pen. pensize(8) # 设置画笔粗细为 8 像素(符合奥委会视觉规范)
# 五环标准配色(国际奥委会官方色值)
colors = [
"#0085C7", # 蓝色环(欧洲) - Pantone Process Cyan C
"#DF0024", # 红色环(美洲) - Pantone Red 032 C
"#000000", # 黑色环(非洲) - Pantone Black 6 C
"#F4C300", # 黄色环(亚洲) - Pantone Yellow 012 C
"#009F3D" # 绿色环(大洋洲) - Pantone Green 356 C
] #五环坐标系统(基于标准比例计算)
positions = [
        (-135,0), # 蓝色环坐标(左上方环,X 轴偏移 -135)
        (135,0), # 红色环坐标(右上方环,X 轴偏移 +135)
        (0,0), # 黑色环坐标(中心环,基准定位点)
        ( -67.5, -71),# 绿色环坐标(左下方环,精确的斜向偏移)
        (67.5,-71) # 黄色环坐标(右下方环,对称偏移设计)
]
def draw_ring(color,x,y):
    """绘制标准奥林匹克圆环
    参数:
    color -环线颜色(HEX 格式)
    x -圆心 X 坐标(数学坐标系)
    y -圆心 Y 坐标(数学坐标系)
    原理:
    海龟绘图默认从底部开始画圆,因此需要将起始点下移半径长度(60 像素)
    """
    pen. penup()
    pen. goto(x,y -60) # 调整起始点到圆心正下方(几何定位算法)
    pen. pendown()
    pen. pencolor(color)
    pen. circle(60) # 绘制半径为 60 像素的标准圆环
# 主绘制流程(遍历颜色和位置数据进行绘制)
for i in range(5):    # 解包坐标参数并调用绘图函数
    draw_ring(colors[i],positions[i][0],positions[i][1])
# 添加奥运标语
pen. penup()
pen. goto(0, -180) # 定位到画布下方(纵坐标 -180)
pen. color("#333333") # 使用深灰色文字
pen. write("同一个世界 同一个梦想",
    align = "center", # 文字居中对齐
    font = ("楷体",20,"bold")) # 使用楷体中文显示
# 完成绘制
pen. hideturtle() # 隐藏画笔图标
turtle. done() # 保持窗口开启(防止自动关闭)